import json
import argparse

if __name__ == "__main__":
	parser = argparse.ArgumentParser(prog="Unity lightmap importer", description="The assimp GLTF2 importer does not read the lightmaps generated by the Unity game engine. This tool modifies the GLTF file so that Assimp will read the light map (aiTextureType_LIGHTMAP)")
	parser.add_argument("filename")
	parser.add_argument("out")
	args = parser.parse_args()

	with open(args.filename) as f:
		gltf_file = json.load(f)

	for material in gltf_file["materials"]:
		lightmap_texture = material["extras"]["metadata"]["lightmapTexture"]
		material["occlusionTexture"] = lightmap_texture

	with open(args.out, "w") as f:
		json.dump(gltf_file, f)