#version 150
// or should I go for #version 330?
 
layout (triangles) in; // Since in OpenGl code "glDrawArrays(GL_TRIANGLES, ...)" is used
layout (triangle_strip, max_vertices = 3) out; // max vertices emitted for a single invocation
 
// Matrices block filled by VSMathLib
layout (std140) uniform Matrices {
	mat4 u_projViewModelMatrix;
	mat4 u_viewModelMatrix;
    mat3 u_viewMatrix;
	mat3 u_normalMatrix;
};

uniform sampler2D s_texUnit;
 
in vec2 texCoord_geom[3];
in vec4 objCoord_geom[3];
 
out vec2 v_texCoord; //output to feed fragment shader

flat out mat4 mTexGridToVpHom_frag;


// B[].zw are intentionally unused
mat4 getAffine2DtransformFromTriMapping(vec2 A[3], vec4 B[3])
{
    // s and t deltas along edge 2 (0 to 2) and edge 1 (0 to 1) of triangle A
    float ds1 = A[1].s - A[0].s;
    float dt1 = A[1].t - A[0].t;
    float ds2 = A[2].s - A[0].s;
    float dt2 = A[2].t - A[0].t;

    // detST; determinant triangle A in (s,t)-space (signed parallelogram area)
    float detST = ds2 * dt1 - ds1 * dt2;
    float rDetST = 1.0f / detST;

    // dxd*
    float dx1 = B[1].x - B[0].x;
    float dx2 = B[2].x - B[0].x;
    float dxds = (dx2 * dt1 - dt2 * dx1) * rDetST; // det(x-t-space) / det(s-t-space)
    float dxdt = (ds2 * dx1 - dx2 * ds1) * rDetST; // det(x-s-space) / det(s-t-space)

    // dyd*
    float dy1 = B[1].y - B[0].y;
    float dy2 = B[2].y - B[0].y;
    float dyds = (dy2 * dt1 - dt2 * dy1) * rDetST; // det(y-t-space) / det(s-t-space)
    float dydt = (ds2 * dy1 - dy2 * ds1) * rDetST; // det(y-s-space) / det(s-t-space)

    // offset of vertex 0 of triangle B
    float xB0 = B[0].x;
    float yB0 = B[0].y;

    // offset of vertex 0 of triangle A
    float xA0 = dxds * A[0].s + dxdt * A[0].t;
    float yA0 = dyds * A[0].s + dydt * A[0].t;

    // Note: GL (and GLM) matrices are column-major
    mat4 M;
    M[0][0] = dxds; M[1][0] = dxdt; M[2][0] = 0;  M[3][0] = xB0 - xA0;  // TODO: omit set values to zero
    M[0][1] = dyds; M[1][1] = dydt; M[2][1] = 0;  M[3][1] = yB0 - yA0;
    M[0][2] = 0;    M[1][2] = 0;    M[2][2] = 1;  M[3][2] = 0;
    M[0][3] = 0;    M[1][3] = 0;    M[2][3] = 0;  M[3][3] = 1;
    return M;
}

mat4 getNormalizedtoViewport(ivec2 vpSize)
{
    mat4 sc = mat4(1); sc[0][0] = vpSize.x/2.0; sc[1][1] = vpSize.y/2.0; // scale part
    mat4 tr = mat4(1); tr[3] = vec4(+vpSize/2, 0, 1); // translate part
    return tr * sc;
}

mat4 getTexGridToNormalized(ivec2 texSize)
{
    mat4 sc = mat4(1); sc[0][0] = 1.0/texSize.x; sc[1][1] = 1.0/texSize.y; // scale only
    return sc;
}


// pass-through geometry shader
void main()
{
    // Obtain the forward perspective transformation in mTexToClip
    // from 2D texture (normalized) space into (homogeneous) Clip space.
    mat4 mTexToObj = getAffine2DtransformFromTriMapping(texCoord_geom, objCoord_geom);
    mat4 mTexToClip = u_projViewModelMatrix * mTexToObj;

    // "Scale" this normalized transformation: from texture grid to viewport (hom) grid space,
    // in mTexGridToVpHom_frag and output as per triangle constant (flat out).
    ivec2 vpSize = ivec2(512, 512);
    mat4 mTexToVpHom = getNormalizedtoViewport(vpSize) * mTexToClip;
    ivec2 texSize = textureSize(s_texUnit, 0);
    mTexGridToVpHom_frag = mTexToVpHom * getTexGridToNormalized(texSize);

    // Unmodified pass through vertex coordinates in texture space and viewport space.
    for(int i = 0; i < gl_in.length(); i++)
    {
        // copy attributes
        gl_Position = gl_in[i].gl_Position;
        v_texCoord = texCoord_geom[i];
        EmitVertex();
    }
    EndPrimitive();
}
