#version 150

// We use following convention of variable name prefixes:
// u_   uniform - may change per primitive, from appl to any shader
// s_   uniform sampler - associated with a texture unit having a texture map
// a_   attribute  per vertex attribute, appl to vertex shader
// v_   varying  used for interpolated values from vertex shader to fragment shader

// Matrices block filled by VSMathLib
layout (std140) uniform Matrices {
	mat4 u_projViewModelMatrix;
	mat4 u_viewModelMatrix;
    mat3 u_viewMatrix;
	mat3 u_normalMatrix;
};

uniform vec3 u_lightDir;

in vec2 a_texCoord;
in vec4 a_objCoord;

#if 0  // To disable geometry shader
    out vec2 v_texCoord; //output to feed to fragment shader
#else // with geometry shader enabled
    out vec2 texCoord_geom; //output to feed to geometry shader
    out vec4 objCoord_geom;
#endif


void main ()
{
	texCoord_geom = a_texCoord;
    objCoord_geom = a_objCoord;
	gl_Position = u_projViewModelMatrix * a_objCoord;	
}