// Hygx cubic filter function for B=0 and C=1

#version 430

#define SIGN(x)           ( int(x >= 0) - int(x < 0) )  // GLSL sign(0) gives 0 i.s.o 1

// #defines and globals
#define POW2(x)	((x)*(x))
#define POW3(x)	((x)*(x)*(x))
#define POW4(x)	((x)*(x)*(x)*(x))
#define POW5(x)	((x)*(x)*(x)*(x)*(x))
#define POW6(x)	((x)*(x)*(x)*(x)*(x)*(x))
#define POW7(x)	((x)*(x)*(x)*(x)*(x)*(x)*(x))
#define POW8(x)	((x)*(x)*(x)*(x)*(x)*(x)*(x)*(x))

float X2, X3, X4, X5, X6, X7, X8;
float T2, T3, T4, T5, T6, T7, T8;
float Y2, Y3, Y4, Y5, Y6, Y7, Y8;

#pragma region Base integral Cell expressions
// generated in cubicMitchell-mm113_4x4cellsAproach.nb

float i2cell00_B1C0(float x, float t, float y0) {
    return
    (POW4(2 + x)*(T4*(16 - 32*x + 40*X2 - 40*X3 + 35*X4) + 32*T3*(-2 + 4*x - 5*X2 + 5*X3)*(2 + y0) + 56*T2*(2 - 4*x + 5*X2)*POW2(2 + y0) + 112*t*(-1 + 2*x)*POW3(2 + y0) + 70*POW4(2 + y0)))/40320.;
}
float i2cell10_B1C0(float x, float t, float y0) {
    return
    (T4*(252 + 224*X5 - 240*X7 - 105*X8) - 32*T3*(31 - 35*X4 + 35*X6 + 15*X7)*(2 + y0) - 56*T2*(-30 - 40*X3 + 36*X5 + 15*X6)*POW2(2 + y0) - 112*t*(14 - 20*X2 + 15*X4 + 6*X5)*POW3(2 + y0) - 70*(-12 - 16*x + 8*X3 + 3*X4)*POW4(2 + y0))/40320.;
}
float i2cell20_B1C0(float x, float t, float y0) {
    return
    (T4*(252 + 224*X5 - 240*X7 + 105*X8) + 32*T3*(-31 + 35*X4 - 35*X6 + 15*X7)*(2 + y0) + 56*T2*(30 + 40*X3 - 36*X5 + 15*X6)*POW2(2 + y0) + 112*t*(-14 + 20*X2 - 15*X4 + 6*X5)*POW3(2 + y0) + 70*(12 + 16*x - 8*X3 + 3*X4)*POW4(2 + y0))/40320.;
}
float i2cell30_B1C0(float x, float t, float y0) {
    return
    (176*T4 - 35*T4*X8 - 1024*T3*(2 + y0) + 224*T2*POW2(2 + y0) - 1792*t*POW3(2 + y0) - 1120*POW4(2 + y0) + 2240*x*POW4(2 + y0) - 560*X2*POW3(2 + y0)*(6 - 8*t + 3*y0) + 80*T3*X7*(3*t - 2*(2 + y0)) + 560*X3*POW2(2 + y0)*(8*T2 - 8*t*(2 + y0) + POW2(2 + y0)) - 280*T2*X6*(2*T2 - 4*t*(2 + y0) + POW2(2 + y0)) + 224*t*X5*(2*T3 - 12*T2*(2 + y0) + 9*t*POW2(2 + y0) - POW3(2 + y0)) - 70*X4*(2 + y0)*(-32*T3 + 72*T2*(2 + y0) - 24*t*POW2(2 + y0) + POW3(2 + y0)) + 24*(3*T4 + 56*T2*POW2(2 + y0) + 70*POW4(2 + y0)))/40320.;
}
float i2cell01_B1C0(float x, float t, float y0) {
    return
    -(POW4(2 + x)*(3*T4*(16 - 32*x + 40*X2 - 40*X3 + 35*X4) + 32*T3*(-2 + 4*x - 5*X2 + 5*X3)*(2 + 3*y0) + 56*T2*(2 - 4*x + 5*X2)*y0*(4 + 3*y0) + 112*t*(-1 + 2*x)*(-4 + 6*Y2 + 3*Y3) + 70*(-12 - 16*y0 + 8*Y3 + 3*Y4)))/40320.;
}
float i2cell11_B1C0(float x, float t, float y0) {
    return
    T4*(-0.01875 - X5/60. + X7/56. + X8/128.) + (T3*(31 - 35*X4 + 35*X6 + 15*X7)*(2 + 3*y0))/1260. + (T2*(-30 - 40*X3 + 36*X5 + 15*X6)*y0*(4 + 3*y0))/720. + (t*(14 - 20*X2 + 15*X4 + 6*X5)*(-4 + 6*Y2 + 3*Y3))/360. + ((-12 - 16*x + 8*X3 + 3*X4)*(-12 - 16*y0 + 8*Y3 + 3*Y4))/576.;
}
float i2cell21_B1C0(float x, float t, float y0) {
    return
    (-3*T4*(252 + 224*X5 - 240*X7 + 105*X8) - 32*T3*(-31 + 35*X4 - 35*X6 + 15*X7)*(2 + 3*y0) - 56*T2*(30 + 40*X3 - 36*X5 + 15*X6)*y0*(4 + 3*y0) - 112*t*(-14 + 20*X2 - 15*X4 + 6*X5)*(-4 + 6*Y2 + 3*Y3) - 70*(12 + 16*x - 8*X3 + 3*X4)*(-12 - 16*y0 + 8*Y3 + 3*Y4))/40320.;
}
float i2cell31_B1C0(float x, float t, float y0) {
    return
    (3*T4*(-248 - 448*X5 + 560*X6 - 240*X7 + 35*X8) + 32*T3*POW4(-2 + x)*(2 + 4*x + 5*X2 + 5*X3)*(2 + 3*y0) + 56*T2*(-28 - 80*X3 + 90*X4 - 36*X5 + 5*X6)*y0*(4 + 3*y0) + 112*t*POW4(-2 + x)*(1 + 2*x)*(-4 + 6*Y2 + 3*Y3) + 70*(-8 - 32*x + 24*X2 - 8*X3 + X4)*(-12 - 16*y0 + 8*Y3 + 3*Y4))/40320.;
}
float i2cell02_B1C0(float x, float t, float y0) {
    return
    (POW4(2 + x)*(3*T4*(16 - 32*x + 40*X2 - 40*X3 + 35*X4) + 56*T2*(2 - 4*x + 5*X2)*y0*(-4 + 3*y0) + 32*T3*(-2 + 4*x - 5*X2 + 5*X3)*(-2 + 3*y0) + 112*t*(-1 + 2*x)*(4 - 6*Y2 + 3*Y3) + 70*(12 + 16*y0 - 8*Y3 + 3*Y4)))/40320.;
}
float i2cell12_B1C0(float x, float t, float y0) {
    return
    T4*(0.01875 + X5/60. - X7/56. - X8/128.) - (T2*(-30 - 40*X3 + 36*X5 + 15*X6)*y0*(-4 + 3*y0))/720. - (T3*(31 - 35*X4 + 35*X6 + 15*X7)*(-2 + 3*y0))/1260. - (t*(14 - 20*X2 + 15*X4 + 6*X5)*(4 - 6*Y2 + 3*Y3))/360. - ((-12 - 16*x + 8*X3 + 3*X4)*(12 + 16*y0 - 8*Y3 + 3*Y4))/576.;
}
float i2cell22_B1C0(float x, float t, float y0) {
    return
    T4*(0.01875 + X5/60. - X7/56. + X8/128.) + (T2*(30 + 40*X3 - 36*X5 + 15*X6)*y0*(-4 + 3*y0))/720. + (T3*(-31 + 35*X4 - 35*X6 + 15*X7)*(-2 + 3*y0))/1260. + (t*(-14 + 20*X2 - 15*X4 + 6*X5)*(4 - 6*Y2 + 3*Y3))/360. + ((12 + 16*x - 8*X3 + 3*X4)*(12 + 16*y0 - 8*Y3 + 3*Y4))/576.;
}
float i2cell32_B1C0(float x, float t, float y0) {
    return
    (-3*T4*(-248 - 448*X5 + 560*X6 - 240*X7 + 35*X8) - 56*T2*(-28 - 80*X3 + 90*X4 - 36*X5 + 5*X6)*y0*(-4 + 3*y0) - 32*T3*POW4(-2 + x)*(2 + 4*x + 5*X2 + 5*X3)*(-2 + 3*y0) - 112*t*POW4(-2 + x)*(1 + 2*x)*(4 - 6*Y2 + 3*Y3) - 70*(-8 - 32*x + 24*X2 - 8*X3 + X4)*(12 + 16*y0 - 8*Y3 + 3*Y4))/40320.;
}
float i2cell03_B1C0(float x, float t, float y0) {
    return
    (POW4(2 + x)*(1680 - T4*(16 - 32*x + 40*X2 - 40*X3 + 35*X4) - 32*T3*(-2 + 4*x - 5*X2 + 5*X3)*(-2 + y0) - 56*T2*(2 - 4*x + 5*X2)*POW2(-2 + y0) - 112*t*(-1 + 2*x)*POW3(-2 + y0) - 70*POW4(-2 + y0)))/40320.;
}
float i2cell13_B1C0(float x, float t, float y0) {
    return
    (T4*(-252 - 224*X5 + 240*X7 + 105*X8) + 32*T3*(31 - 35*X4 + 35*X6 + 15*X7)*(-2 + y0) + 56*T2*(-30 - 40*X3 + 36*X5 + 15*X6)*POW2(-2 + y0) + 112*t*(14 - 20*X2 + 15*X4 + 6*X5)*POW3(-2 + y0) + 70*(-12 - 16*x + 8*X3 + 3*X4)*(-8 - 32*y0 + 24*Y2 - 8*Y3 + Y4))/40320.;
}
float i2cell23_B1C0(float x, float t, float y0) {
    return
    (-(T4*(252 + 224*X5 - 240*X7 + 105*X8)) - 32*T3*(-31 + 35*X4 - 35*X6 + 15*X7)*(-2 + y0) - 56*T2*(30 + 40*X3 - 36*X5 + 15*X6)*POW2(-2 + y0) - 112*t*(-14 + 20*X2 - 15*X4 + 6*X5)*POW3(-2 + y0) - 70*(12 + 16*x - 8*X3 + 3*X4)*(-8 - 32*y0 + 24*Y2 - 8*Y3 + Y4))/40320.;
}
float i2cell33_B1C0(float x, float t, float y0) {
    return
    (40320 + T4*(-176 - 448*X5 + 560*X6 - 240*X7 + 35*X8) + 32*T3*POW4(-2 + x)*(2 + 4*x + 5*X2 + 5*X3)*(-2 + y0) + 56*T2*(-4 - 80*X3 + 90*X4 - 36*X5 + 5*X6)*POW2(-2 + y0) + 112*t*POW4(-2 + x)*(1 + 2*x)*POW3(-2 + y0) + 70*POW4(-2 + x)*POW4(-2 + y0) - 24*(3*T4 + 56*T2*POW2(-2 + y0) + 70*(32 - 32*x + 24*X2 - 8*X3 + X4 - 32*y0 + 24*Y2 - 8*Y3 + Y4)))/40320.;
}

#pragma endregion 

#pragma region horizontal cell borders constant expressions
// generated in cubicMitchell-mm113_4x4cellsAproach.nb

float HygxBorder04_B1C0(float t, float y0) {
    return
    POW8(-2 - 2*t + y0)/(40320.*POW4(t));
}
float HygxBorder14_B1C0(float t, float y0) {
    return
    (252*T8 - 992*T7*(-2 + y0) + 1680*T6*POW2(-2 + y0) - 1568*T5*POW3(-2 + y0) + 840*T4*POW4(-2 + y0) - 224*T3*POW5(-2 + y0) + 16*t*POW7(-2 + y0) - 3*POW8(-2 + y0))/(40320.*POW4(t));
}
float HygxBorder24_B1C0(float t, float y0) {
    return
    (252*T8 - 992*T7*(-2 + y0) + 1680*T6*POW2(-2 + y0) - 1568*T5*POW3(-2 + y0) + 840*T4*POW4(-2 + y0) - 224*T3*POW5(-2 + y0) + 16*t*POW7(-2 + y0) + 3*POW8(-2 + y0))/(40320.*POW4(t));
}
float HygxBorder34_B1C0(float t, float y0) {
    return
    -(-248*T8 + 1024*T7*(-2 + y0) - 1568*T6*POW2(-2 + y0) + 1792*T5*POW3(-2 + y0) - 560*T4*POW4(-2 + y0) + 448*T3*POW5(-2 + y0) + 112*T2*POW6(-2 + y0) + 16*t*POW7(-2 + y0) + POW8(-2 + y0))/(40320.*POW4(t));
}
float HygxBorder03_B1C0(float t, float y0) {
    return
    -POW8(-1 - 2*t + y0)/(10080.*POW4(t));
}
float HygxBorder13_B1C0(float t, float y0) {
    return
    (-252*T8 + 992*T7*(-1 + y0) - 1680*T6*POW2(-1 + y0) + 1568*T5*POW3(-1 + y0) - 840*T4*POW4(-1 + y0) + 224*T3*POW5(-1 + y0) - 16*t*POW7(-1 + y0) + 3*POW8(-1 + y0))/(10080.*POW4(t));
}
float HygxBorder23_B1C0(float t, float y0) {
    return
    -(252*T8 - 992*T7*(-1 + y0) + 1680*T6*POW2(-1 + y0) - 1568*T5*POW3(-1 + y0) + 840*T4*POW4(-1 + y0) - 224*T3*POW5(-1 + y0) + 16*t*POW7(-1 + y0) + 3*POW8(-1 + y0))/(10080.*POW4(t));
}
float HygxBorder33_B1C0(float t, float y0) {
    return
    (-248*T8 + 1024*T7*(-1 + y0) - 1568*T6*POW2(-1 + y0) + 1792*T5*POW3(-1 + y0) - 560*T4*POW4(-1 + y0) + 448*T3*POW5(-1 + y0) + 112*T2*POW6(-1 + y0) + 16*t*POW7(-1 + y0) + POW8(-1 + y0))/(10080.*POW4(t));
}
float HygxBorder02_B1C0(float t, float y0) {
    return
    POW8(-2*t + y0)/(6720.*POW4(t));
}
float HygxBorder12_B1C0(float t, float y0) {
    return
    (252*T8 - 992*T7*y0 + 1680*T6*Y2 - 1568*T5*Y3 + 840*T4*Y4 - 224*T3*Y5 + 16*t*Y7 - 3*Y8)/(6720.*POW4(t));
}
float HygxBorder22_B1C0(float t, float y0) {
    return
    (252*T8 - 992*T7*y0 + 1680*T6*Y2 - 1568*T5*Y3 + 840*T4*Y4 - 224*T3*Y5 + 16*t*Y7 + 3*Y8)/(6720.*POW4(t));
}
float HygxBorder32_B1C0(float t, float y0) {
    return
    -(-248*T8 + 1024*T7*y0 - 1568*T6*Y2 + 1792*T5*Y3 - 560*T4*Y4 + 448*T3*Y5 + 112*T2*Y6 + 16*t*Y7 + Y8)/(6720.*POW4(t));
}
float HygxBorder01_B1C0(float t, float y0) {
    return
    -POW8(1 - 2*t + y0)/(10080.*POW4(t));
}
float HygxBorder11_B1C0(float t, float y0) {
    return
    (-252*T8 + 992*T7*(1 + y0) - 1680*T6*POW2(1 + y0) + 1568*T5*POW3(1 + y0) - 840*T4*POW4(1 + y0) + 224*T3*POW5(1 + y0) - 16*t*POW7(1 + y0) + 3*POW8(1 + y0))/(10080.*POW4(t));
}
float HygxBorder21_B1C0(float t, float y0) {
    return
    -(252*T8 - 992*T7*(1 + y0) + 1680*T6*POW2(1 + y0) - 1568*T5*POW3(1 + y0) + 840*T4*POW4(1 + y0) - 224*T3*POW5(1 + y0) + 16*t*POW7(1 + y0) + 3*POW8(1 + y0))/(10080.*POW4(t));
}
float HygxBorder31_B1C0(float t, float y0) {
    return
    (-248*T8 + 1024*T7*(1 + y0) - 1568*T6*POW2(1 + y0) + 1792*T5*POW3(1 + y0) - 560*T4*POW4(1 + y0) + 448*T3*POW5(1 + y0) + 112*T2*POW6(1 + y0) + 16*t*POW7(1 + y0) + POW8(1 + y0))/(10080.*POW4(t));
}
float HygxBorder00_B1C0(float t, float y0) {
    return
    POW8(2 - 2*t + y0)/(40320.*POW4(t));
}
float HygxBorder10_B1C0(float t, float y0) {
    return
    (216*T8 - 752*T7*(2 + y0) + 1008*T6*POW2(2 + y0) - 560*T5*POW3(2 + y0) + 112*T3*POW5(2 + y0) - 32*t*POW7(2 + y0) + 9*POW8(2 + y0) + 12*POW7(-2 + t - y0)*(2 + 3*t + y0))/(40320.*POW4(t));
}
float HygxBorder20_B1C0(float t, float y0) {
    return
    (252*T8 - 992*T7*(2 + y0) + 1680*T6*POW2(2 + y0) - 1568*T5*POW3(2 + y0) + 840*T4*POW4(2 + y0) - 224*T3*POW5(2 + y0) + 16*t*POW7(2 + y0) + 3*POW8(2 + y0))/(40320.*POW4(t));
}
float HygxBorder30_B1C0(float t, float y0) {
    return
    -(-176*T8 + 1024*T7*(2 + y0) - 224*T6*POW2(2 + y0) + 1792*T5*POW3(2 + y0) + 1120*T4*POW4(2 + y0) + 448*T3*POW5(2 + y0) + 112*T2*POW6(2 + y0) + 16*t*POW7(2 + y0) + POW8(2 + y0) - 24*T4*(3*T4 + 56*T2*POW2(2 + y0) + 70*POW4(2 + y0)))/(40320.*POW4(t));
}


#pragma endregion 

#pragma region Hygx_cubic
float Hygx_cubic_B1C0(float xIn, float t, float y0)
{
    float x = min(xIn, 1.9999);   // clip x against right border of filter footprint
                                // such that value at x==2 is being repeated for all x>2
                                // TODO: change 1.9999 into 2.0
    float gx = t * x + y0;  // y=g(x) defines the (diagonal) line where integration is along

    if (x <= -2.0 + 0.0001) return 0; // to the west of all cells, obtaining weight = 0
    // Next "early exit" can safely be omitted.
    if (t >= 0 && gx < -2) return 0; // to the south of all cells, only with positive tangent, obtains weight = 0

    // first, evaluate base integral Hygx-cells for the 16 cell area's
    // ---------------------------------------------------------------
    float wBase = 0; // weight of cell integral (with constants for vertical line x == -2,-1,0,1,2)

    // globals; made powers of x and t globals to reduce code redundancy for now.
    // Compute these powers here i.s.o. in each of the cell functions
    X2 = x*x; X3 = X2*x; X4 = X3*x; X5 = X4*x; X6 = X5*x; X7 = X6*x; X8 = X7*x;
    T2 = t*t; T3 = T2*t; T4 = T3*t; T5 = T4*t; T6 = T5*t; T7 = T6*t; T8 = T7*t;
    Y2 = y0*y0; Y3 = Y2*y0; Y4 = Y3*y0; Y5 = Y4*y0; Y6 = Y5*y0; Y7 = Y6*y0; Y8 = Y7*y0;

    // NOTE: ONLY THE BASE FUNCTIONS WITHIN THE AA-FILTER FOOTPRINT NEED TO BE IMPLEMENTED
    // VERTICAL CLIPPING IN WtEdgeAB ensures functions outside are not required.
    if (x < -1) // -2 <= x < -1: we are in cell00, cell01, cell02 or cell03
    {
        if      (gx >= +1) { wBase = i2cell03_B1C0(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell02_B1C0(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell01_B1C0(x, t, y0); }
        else               { wBase = i2cell00_B1C0(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else if (x<0) // -1 <= x < 0: we are in cell10, cell11, cell12 or cell13
    {
        if      (gx >= +1) { wBase = i2cell13_B1C0(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell12_B1C0(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell11_B1C0(x, t, y0); }
        else               { wBase = i2cell10_B1C0(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else if (x<+1) // 0 <= x < +1: we are in cell20, cell21, cell22 or cell23
    {
        if      (gx >= +1) { wBase = i2cell23_B1C0(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell22_B1C0(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell21_B1C0(x, t, y0); }
        else               { wBase = i2cell20_B1C0(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }
    else           // +1 <= x < +2: we are in cell30, cell31, cell32 or cell33
    {
        if      (gx >= +1) { wBase = i2cell33_B1C0(x, t, y0); }
        else if (gx >=  0) { wBase = i2cell32_B1C0(x, t, y0); }
        else if (gx >= -1) { wBase = i2cell31_B1C0(x, t, y0); }
        else               { wBase = i2cell30_B1C0(x, t, y0); /*ASSERT(gx > -2.0 - 0.0001);*/ }
    }

    // second, add diagonal "row"-constants ALLONG TANGENT LINE for (overlapping) area's
    // ---------------------------------------------------------------------------------

    // Compute integral constants at horizontal cell piecewise discontinuities at HygxBorder[xy]
    // Where [xy] indicate the bottom border of cell[xy].
    // 2D overlapping area's of constants are defined by 
    // - horizontal range   where x is restricted to -2 < x < +2
    // - vertical range     where gx is restricted
    // - diagonal range     where y0 is restricted

    float wConst = 0;
    int st = SIGN(t);

    // HygxBorder*4: Only needed for negative tangent; below horizontal line: g(x) = +2
    if (t < 0 && gx <= 2.0001)
    {
        // Border04 for negative t:  y0 <= 2 + t  &&  y0 > 2 + 2t (since st=-1, conditions can be simplified)
        if      ( ((2 +   t - y0)*st <= 0)  &&  ((2 + 2*t - y0)*st > 0) ) wConst += HygxBorder04_B1C0(t, y0);
        else if ( ((2       - y0)*st <= 0)  &&  ((2 +   t - y0)*st > 0) ) wConst += HygxBorder14_B1C0(t, y0);
        else if ( ((2 -   t - y0)*st <= 0)  &&  ((2       - y0)*st > 0) ) wConst += HygxBorder24_B1C0(t, y0);
        else if (/*(2 - 2*t - y0)*st <= 0 */    ((2 -   t - y0)*st > 0) ) wConst += HygxBorder34_B1C0(t, y0);
    }
    // HygxBorder*3: For positive and negative tangent; above respectively below horizontal line: g(x) = +1
    if ( (t >= 0 && gx >= 1) || (t < 0 && gx < 1) )
    {
        // Border03 positive t: y0 >= 1 + t  &&  y0 < 1 + 2t, negative t: y0 <= 1 + t  &&  y0 > 1 + 2t
        if      ( ((1 +   t - y0)*st <= 0)  &&  ((1 + 2*t - y0)*st > 0) ) wConst += HygxBorder03_B1C0(t, y0);
        else if ( ((1       - y0)*st <= 0)  &&  ((1 +   t - y0)*st > 0) ) wConst += HygxBorder13_B1C0(t, y0);
        else if ( ((1 -   t - y0)*st <= 0)  &&  ((1       - y0)*st > 0) ) wConst += HygxBorder23_B1C0(t, y0);
        else if (/*(1 - 2*t - y0)*st <= 0 */    ((1 -   t - y0)*st > 0) ) wConst += HygxBorder33_B1C0(t, y0);
    }
    // HygxBorder*2: For positive and negative tangent; above respectively below horizontal line: g(x) = 0
    if ( (t >= 0 && gx >= 0) || (t < 0 && gx < 0) )
    {
        // Border02 positive t: y0 >= 0 + t  &&  y0 < 0 + 2t, negative t: y0 <= 0 + t  &&  y0 > 0 + 2t
        if      ( ((0 +   t - y0)*st <= 0)  &&  ((0 + 2*t - y0)*st > 0) ) wConst += HygxBorder02_B1C0(t, y0);
        else if ( ((0       - y0)*st <= 0)  &&  ((0 +   t - y0)*st > 0) ) wConst += HygxBorder12_B1C0(t, y0);
        else if ( ((0 -   t - y0)*st <= 0)  &&  ((0       - y0)*st > 0) ) wConst += HygxBorder22_B1C0(t, y0);
        else if (/*(0 - 2*t - y0)*st <= 0 */    ((0 -   t - y0)*st > 0) ) wConst += HygxBorder32_B1C0(t, y0);
    }
    // HygxBorder*1: For positive and negative tangent; above respectively below horizontal line: g(x) = -1
    if ( (t >= 0 && gx >= -1) || (t < 0 && gx < -1) )
    {
        // Border01 positive t: y0 >= -1 + t  &&  y0 < -1 + 2t, negative t: y0 <= -1 + t  &&  y0 > -1 + 2t
        if      ( ((-1 +   t - y0)*st <= 0)  &&  ((-1 + 2*t - y0)*st > 0) ) wConst += HygxBorder01_B1C0(t, y0);
        else if ( ((-1       - y0)*st <= 0)  &&  ((-1 +   t - y0)*st > 0) ) wConst += HygxBorder11_B1C0(t, y0);
        else if ( ((-1 -   t - y0)*st <= 0)  &&  ((-1       - y0)*st > 0) ) wConst += HygxBorder21_B1C0(t, y0);
        else if (/*(-1 - 2*t - y0)*st <= 0 */    ((-1 -   t - y0)*st > 0) ) wConst += HygxBorder31_B1C0(t, y0);
    }
    // HygxBorder*0: Only needed for positive tangent; above horizontal line: g(x) = -2
    if ( t > 0 && gx >= -2 )
    {
        // Border00 positive t: y0 >= -2 + t  &&  y0 < -2 + 2t (since st=1, conditions can be simplified)
        if      ( ((-2 +   t - y0)*st <= 0)  &&  ((-2 + 2*t - y0)*st > 0) ) wConst += HygxBorder00_B1C0(t, y0);
        else if ( ((-2       - y0)*st <= 0)  &&  ((-2 +   t - y0)*st > 0) ) wConst += HygxBorder10_B1C0(t, y0);
        else if ( ((-2 -   t - y0)*st <= 0)  &&  ((-2       - y0)*st > 0) ) wConst += HygxBorder20_B1C0(t, y0);
        else if (/*(-2 - 2*t - y0)*st <= 0 */    ((-2 -   t - y0)*st > 0) ) wConst += HygxBorder30_B1C0(t, y0);
    }

    float weight = wBase - wConst * st;
    return weight;
}
#pragma endregion

// ============================================================================

#pragma region Hyx polynomials
// When tangent=0, i.e. exact horizontal edge. Robust against xa==xb

float HyxCell00_B1C0(float x, float y) {
    return
    (POW4(2 + x)*POW4(2 + y))/576.;
}
float HyxCell10_B1C0(float x, float y) {
    return
    ((12 + 16*x - 8*X3 - 3*X4)*POW4(2 + y))/576.;
}
float HyxCell20_B1C0(float x, float y) {
    return
    ((12 + 16*x - 8*X3 + 3*X4)*POW4(2 + y))/576.;
}
float HyxCell30_B1C0(float x, float y) {
    return
    -((-24 + POW4(-2 + x))*POW4(2 + y))/576.;
}
float HyxCell01_B1C0(float x, float y) {
    return
    (POW4(2 + x)*(12 + 16*y - 8*Y3 - 3*Y4))/576.;
}
float HyxCell11_B1C0(float x, float y) {
    return
    ((-12 - 16*x + 8*X3 + 3*X4)*(-12 - 16*y + 8*Y3 + 3*Y4))/576.;
}
float HyxCell21_B1C0(float x, float y) {
    return
    -((12 + 16*x - 8*X3 + 3*X4)*(-12 - 16*y + 8*Y3 + 3*Y4))/576.;
}
float HyxCell31_B1C0(float x, float y) {
    return
    ((-8 - 32*x + 24*X2 - 8*X3 + X4)*(-12 - 16*y + 8*Y3 + 3*Y4))/576.;
}
float HyxCell02_B1C0(float x, float y) {
    return
    (POW4(2 + x)*(12 + 16*y - 8*Y3 + 3*Y4))/576.;
}
float HyxCell12_B1C0(float x, float y) {
    return
    -((-12 - 16*x + 8*X3 + 3*X4)*(12 + 16*y - 8*Y3 + 3*Y4))/576.;
}
float HyxCell22_B1C0(float x, float y) {
    return
    ((12 + 16*x - 8*X3 + 3*X4)*(12 + 16*y - 8*Y3 + 3*Y4))/576.;
}
float HyxCell32_B1C0(float x, float y) {
    return
    -((-8 - 32*x + 24*X2 - 8*X3 + X4)*(12 + 16*y - 8*Y3 + 3*Y4))/576.;
}
float HyxCell03_B1C0(float x, float y) {
    return
    -(POW4(2 + x)*(-24 + POW4(-2 + y)))/576.;
}
float HyxCell13_B1C0(float x, float y) {
    return
    ((-12 - 16*x + 8*X3 + 3*X4)*(-8 - 32*y + 24*Y2 - 8*Y3 + Y4))/576.;
}
float HyxCell23_B1C0(float x, float y) {
    return
    -((12 + 16*x - 8*X3 + 3*X4)*(-8 - 32*y + 24*Y2 - 8*Y3 + Y4))/576.;
}
float HyxCell33_B1C0(float x, float y) {
    return
    ((-8 - 32*x + 24*X2 - 8*X3 + X4)*(-8 - 32*y + 24*Y2 - 8*Y3 + Y4))/576.;
}


float Hyx_cubicB1C0(float x, float y)
{
	// globals; gives more readable cell functions and reduces redundancy
	X2 = x*x; X3 = X2*x; X4 = X3*x;
    Y2 = y*y; Y3 = Y2*y; Y4 = Y3*y;
    float w = 0;
    if (x < -1) // -2 <= x < -1: we are in cell00, cell01, cell02 or cell03
    {
        if      (y >= +1) w = HyxCell03_B1C0(x, y);
        else if (y >=  0) w = HyxCell02_B1C0(x, y);
        else if (y >= -1) w = HyxCell01_B1C0(x, y);
        else              w = HyxCell00_B1C0(x, y);
    }
    else if (x<0) // -1 <= x < 0: we are in cell10, cell11, cell12 or cell13
    {
        if      (y >= +1) w = HyxCell13_B1C0(x, y);
        else if (y >=  0) w = HyxCell12_B1C0(x, y);
        else if (y >= -1) w = HyxCell11_B1C0(x, y);
        else              w = HyxCell10_B1C0(x, y);
    }
    else if (x<+1) // 0 <= x < +1: we are in cell20, cell21, cell22 or cell23
    {
        if      (y >= +1) w = HyxCell23_B1C0(x, y);
        else if (y >=  0) w = HyxCell22_B1C0(x, y);
        else if (y >= -1) w = HyxCell21_B1C0(x, y);
        else              w = HyxCell20_B1C0(x, y);
    }
    else           // +1 <= x < +2: we are in cell30, cell31, cell32 or cell33
    {
        if      (y >= +1) w = HyxCell33_B1C0(x, y);
        else if (y >=  0) w = HyxCell32_B1C0(x, y);
        else if (y >= -1) w = HyxCell31_B1C0(x, y);
        else              w = HyxCell30_B1C0(x, y);
    }
    return w;
}
#pragma endregion
