#version 330

// We use following convention of variable name prefixes:
// u_   uniform - may change per primitive, from appl to any shader
// s_   uniform sampler - associated with a texture unit having a texture map
// a_   attribute – per vertex attribute, appl to vertex shader
// v_   varying – used for interpolated values from vertex shader to fragment shader

layout (std140) uniform Matrices {
	mat4 u_projViewModelMatrix;
	mat4 u_viewModelMatrix;
    mat3 u_viewMatrix;
	mat3 u_normalMatrix;
};

in vec4 a_position;
in vec4 a_texCoord;

out Data {
	vec4 v_texCoord;
} DataOut;

void main()
{
	DataOut.v_texCoord = a_texCoord;
	gl_Position = u_projViewModelMatrix * a_position ;
} 
